const express = require("express");
const couponController = require("../controllers/couponController");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");

const router = express.Router();

// 1. ✅ PUBLIC ROUTE (Accessible by Guests/Students via API Key)
// Move GET "/" here so the frontend can fetch coupons to show discounts
router.route("/").get(checkApiKey, couponController.getAllCoupons);

// 2. 🔒 PROTECTED ROUTES (Admins Only)
// Everything below this line requires a valid Admin Token
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").post(couponController.createCoupon); // Creating is still protected

router
  .route("/:id")
  .patch(couponController.updateCoupon)
  .delete(couponController.deleteCoupon);

module.exports = router;
